<style>
    .modal-dialog {
        padding: 0 6px;
    }
</style>

<div class="modal notification-modal mt-5" id="notification_modal" tabindex="-1" role="dialog" aria-labelledby="divisionEditModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                @php
                    $notifications = latest_notification(auth()->user()->id); 
                    $notificationCount = $notifications->count();
                @endphp
                @if ($notificationCount > 0)
                    <h6 class="text-sm text-muted m-0" id="exampleModalLabel">
                        <i class="fe fe-bell"></i> You have <strong class="text-primary">{{ $notificationCount }}</strong> new notifications.
                    </h6>
                @endif
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" onclick="closeNotificationModal()">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            
            <div class="list-group list-group-flush">
                @if ($notificationCount > 0)
                    @foreach ($notifications->take(6) as $notification)
                        <div class="list-group-item list-group-item-action">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h4 class="mb-0 text-sm text-uppercase">{{ $notification->message_title }}</h4>
                                </div>
                            </div>
                            <p class="text-sm mb-0">{{ $notification->message }}</p>
                        </div>
                    @endforeach
                @else
                    <div class="list-group-item list-group-item-action text-center">
                        <p>No new notifications</p>
                    </div>
                @endif
            </div>
            
            @if ($notificationCount > 0)
                <a href="{{ route('user.message-list') }}" class="dropdown-item text-center text-primary font-weight-bold py-3">Read all</a>
            @endif
        </div>
    </div>
</div>
